package de.renew.gui;

/**
 * The {@link BreakpointHitEvent} is used to inform possible {@link BreakpointHitListener}s
 * about a breakpoint hit.
 *
 * @author Sven Offermann
 */
public class BreakpointHitEvent {
    public boolean consumed = false;
    public final Breakpoint bp;

    /**
     * Creates a new {@link BreakpointHitEvent} for the specified breakpoint.
     *
     * @param breakpoint the breakpoint that was hit
     */
    public BreakpointHitEvent(Breakpoint breakpoint) {
        this.bp = breakpoint;
    }

    /**
     * Indicates whether the event has already been consumed.
     *
     * <p>An event is considered consumed after its {@link #consume()} method has been invoked.
     *
     * @return Returns {@code true} if the event was consumed, {@code false} otherwise
     */
    public boolean isConsumed() {
        return consumed;
    }

    /**
     * Marks this event as consumed.
     *
     * <p>After this method returns {@link #isConsumed()} will return {@code true}.
     * An event that has been consumed cannot be un-consumed
     */
    public void consume() {
        this.consumed = true;
    }

    /**
     * Returns the breakpoint of this event.
     *
     * @return the breakpoint of this event
     */
    public Breakpoint getBp() {
        return bp;
    }
}
