# Gui

## User Guide

The _Gui Plugin_ provides user interaction for drawing and simulating petri nets.

### Features

- Use menus to access functionality provided by Renew
- Create drawings, reference nets and other models
- Select tools from palettes to manipulate them
- Save them in various formats
- Load nets from disc
- Layout drawings and nets with multiple automatic formatting options
- Customize net and drawing components
- See a visual representation of simulated reference nets and models
- Debug the simulation with Breakpoints and other features
- Access a variety of tools included in Renew
- Use additional functionality that is provided from loaded plugins

### Example Usage

1. Start Renew with the `gui` argument
2. Choose _File -> New Net Drawing (*.rnw)_
3. Select the _Transition Tool_ from the Standard Tools Palette
4. Place a transition in the new net
5. Click on the transition and use it's central interaction point to draw a transition to a new place
6. Select everything and use the _Layout_ menu to align the figures in a desired manner
7. Use the _Attributes_ menu to customize the reference net
8. Select _Simulation -> Run Simulation_ to start a simulation on the selected net
9. Terminate the Simulation in _Simulation -> Terminate Simulation_ or use the shortcut *Ctrl + T*
10. Save the reference net with _File -> Save Drawing_
11. Close Renew

### Provided Commands

- `gui`	- opens the gui and passes command line arguments
- `demonstrator <file> [<file>]` - opens a selection window with given drawing path(s) which allows selecting drawings to show or to close Renew
<!-- Numerous commands that implement `CH.ifa.draw.util.Command`, which can be used in conjunction with ui components.-->

### Installation

Install _Gui_ by putting the JAR file inside the `dist/plugins` directory.

It will be automatically loaded at startup of Renew - see below for more configuration options.

### Dependencies

This plugin depends on the following plugins and external libraries:

<!-- must match the `module-info.java` -->

- `Loader`: (mandated)
- `CH`: Use graphical components, drawing functions and menu management
- `Remote`: Use provided Accessors and Functionality to work with nets
- `Formalism`: Use provided functionality to create net instances and work with them
- `ant`: Create shadow nets in an ant task
- `docking.frames.common`, `docking.frames.core`: Libraries that provide the used graphical elements
- `log4j`: Logging framework

### Configuration
> For default values, see plugin.cfg

**NAME**|**TYPE**|**DESCRIPTION**|**DEFAULT**
:-----|:-----:|:-----|:-----
`de.renew.gui.shutdownOnClose`|`boolean`|Set to true to exit jvm when gui window is closed.|false
`de.renew.gui.autostart`|`boolean`|Set to true to start the gui on loading.|false
`de.renew.gui.noTokenBackground`|`boolean`|Set to true when tokens are displayed without background, set to false when tokens are displayed with a white background.|false
`de.renew.gui.verificationMenu`|`boolean`|Set to true when verification tools should be listed in a separate verification menu.|false
`de.renew.help.gui.title`|`String`|The title as seen in about box dialog.|`About Renew`
`de.renew.help.gui.version`|`String`|The version as seen in about box dialog.|`<h3>Renew development version</h3>\nInternal use only`
`de.renew.help.gui.content`|`String`|The authors as seen in about box dialog.|`<p>\u00a9 2020 Kummer, Wienberg, Duvigneau, Cabac, Haustermann, Mosteller</p>\<p>Further credits are given in the renew user guide.</p>`
`de.renew.help.gui.enableLinks`|`boolean`|If true Links are enabled.|true
`de.renew.help.gui.revision`|`int`|The revision as seen in about box dialog.|

##Developer Guide

### Core Classes and Methods

#### 0. GuiPlugin

Implements the `IPlugin` interface to manage the startup and shutdown.
Contains a number of interface methods that
can be used by other plugins to extend the functionality and to access data.
It serves as a Facade for the whole plugin; this has the advantage that
the functionality can be provided even if no window is shown.

#### 1. Menus: 

The menu handling has changed! It is now under control of the `CH.ifa.draw-Plugin`.  
You can find the documentation for menu access in its `README.md`.  
Menus are added by obtaining a MenuHolder object via the `getMenuHolder()` method.  
It provides the following methods:

- `addMenu(JMenuItem menu)`  
Adds the given `JMenuItem` to the "plugins" menu.  
It is the responsibility of the caller to create the menu entries and functionality.

- `addMenuItem(String menu, JMenuItem added)`  
Adds the given `JMenuItem` to the menu designated by the given menu String.  
The Menu names that can be used are available as static final
class variables in the `MenuHolder` class.  
The menu items are added first come, first served;  
an ordering is not enforced. 
	
- `removeMenuItem(JMenuItem menu)`  
Removes the given menu item.

#### 2. Palettes:

Palettes are sometimes also called "toolbars";  
To add palettes to the gui, obtain a `PaletteHolder` object (by default an instance of `GuiPalettes`) via the `getPaletteHolder()` method  
which provides the following interface:

- `addPalette(Palette palette)`  
Adds the given palette to the frame.

- `createToolButton(javax.swing.Icon icon, Icon selectedIcon, String toolName, de.renew.draw.ui.ontology.Tool tool)`  
Creates a button for a desired palette.

- `createToolButton(String path, String toolName, Tool tool)`  
Creates a button for a desired palette, trying to get the image info from the given path.
								
- `removePalette(Palette p)`  
Removes the given palette from the gui.

#### 3. Drawing and window access

- `getGuiFrame()` - returns the application frame window  
*It should not be stored for later use since the window may
be disposed in between;  
it can be used for creating dialogs that need a parent window object.*
- `getView(Drawing d)` - returns the window in which the given drawing is edited
- `promptNew()` - creates a new drawing and shows it in editor
- `promptNew(Drawing d)` - creates a new editor for the given drawing
- `showStatus(String st)` - shows the given String in the main window's status line

#### 4. Load and save support

To extend the functionality of renew regarding its load/save capabilities,  
obtain an `ImportExportHolder` object by calling the gui's `getImportExportHolder()` function.  
It implements both the `ImportHolder` and `ExportHolder` interfaces, providing:

- `addImportFormat(ImportFormat format)`	- registers the ImportFormat that can be used to load nets from files
- `removeImportFormat(ImportFormat format)`	- removes the ImportFormat that is used to load nets from files
- `allImportFormats()`				- returns all ImportFormats available in an array

All methods are available for `ExportFormat`, respectively.

#### 5. Figure creation

To tweak the way the gui creates figures during net design time, a `FigureCreationHolder` object  
can be obtained from the `GuiPlugin`, making available the following methods:

- `registerCreator(FigureCreator)` - register the FigureCreator object;   
this will be used to display
								tokens in a running simulation.
- `unregisterCreator(FigureCreator)` - remove the FigureCreator
- `registerCreator(TextFigureCreator)` - register the TextFigureCreator object;  
this will be used to create a
								standard inscription for a figure when drawing the net.
- `unregisterCreator(TextFigureCreator)` - remove the TextFigureCreator

#### 6. Renew-specific operations

- `processSyntaxException(SyntaxException ex)` - handles the given exception

### How to extend

_Gui_ exposes 21 public interfaces. You can implement these interfaces to add additional functionality to the Gui.

- `de.remew.gui.controller.ConfigureSimulationTabController` - an implementation of this interface is used for each option tab managed by the `ConfigureSimulationController`
- `de.remew.gui.pnml.converter.NetConverter` - used to convert between the contents of a `de.renew.gui.CPNDrawing` (in the form of `de.renew.draw.storables.ontology.Figure` objects) and the contents of an `Element` representing the same net in a PNML file
- `de.remew.gui.Breakpoint - Breakpoints observe the simulation of a net and stop its execution if a certain event occurs`
- `de.remew.gui.BreakpointHitListener` - describes the listener interface that must be implemented by objects which wants to be informed, if a breakboint is hit in a simulation
- `de.remew.gui.FigureCreator` - This interface is implemented by classes that decide how a token type will be represented in the gui. To use a class implementing this, it needs to be registered in the `GuiPlugin`
- `de.remew.gui.FigureCreatorHolder`
- `de.remew.gui.FigureWithHighlight` - interface for Figures which can have an associated highlight figure
- `de.remew.gui.InscribableFigure` - Tag interface for figures which have a semantical meaning (ShadowHolders) and can include inscriptions
- `de.remew.gui.InstanceDrawingFactory`
- `de.remew.gui.InstanceFigure`
- `de.remew.gui.LayoutableDrawing`
- `de.remew.gui.NodeFigure` - tag Interface as a common type of TransitionFigure, PlaceFigure, and other node-like net components
- `de.remew.gui.PaletteHolder`
- `de.remew.gui.PlaceNodeFigure` - tag Interface for PlaceFigures
- `de.remew.gui.SemanticUpdateFigure`
- `de.remew.gui.ShadowHolder`
- `de.remew.gui.TextFigureCreator`
- `de.remew.gui.Token` - a class that may occur as a token in a Petri net may implement the interface `Token`. The class needs to implement a single method that returns an object that describes the graphical appearance of the token
- `de.remew.gui.TokenHandle`
- `de.remew.gui.TransitionNodeFigure` - tag Interface for TransitionFigures
- `de.remew.gui.XMLFormat` - present an abstract way of generating and parsing XML files. This interface allows us to compile the main part of Renew without referencing any XML parser libraries. Furthermore, we can easily swap XML file formats

### Additional Information

- This plugin is used to register components for user interaction
- Currently, it is necessary to include this plugin to run Renew as it handles most interactions during runtime