package de.renew.formalism.java;

import org.junit.jupiter.api.Test;

import de.renew.expression.ConstantExpression;
import de.renew.expression.Expression;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;

public class TypedExpressionTest {
    @Test
    public void testToString() {
        // given
        Class<?> type = Integer.class;
        int value = 42;
        TypedExpression expr = new TypedExpression(type, new ConstantExpression(type, value));

        // when
        String str = expr.toString();

        // then
        assertEquals("TypedExpr(java.lang.Integer: ConstantExpr(java.lang.Integer: 42))", str);
    }

    @Test
    public void testGetExpression() {
        // given
        Class<?> type = Integer.class;
        int value = 42;
        Expression origExpression = new ConstantExpression(type, value);
        TypedExpression expr = new TypedExpression(type, origExpression);

        // when
        Expression valueExpression = expr.getExpression();

        // then
        assertEquals(origExpression, valueExpression);
    }

    @Test
    public void testGetType() {
        // given
        Class<?> type = Integer.class;
        int value = 42;
        Expression origExpression = new ConstantExpression(type, value);
        TypedExpression expr = new TypedExpression(type, origExpression);

        // when
        Class<?> theType = expr.getType();

        // then
        assertEquals(type, theType);
    }

    @Test
    public void testIsTypedPositive() {
        // given
        Class<?> type = Integer.class;
        int value = 42;
        Expression origExpression = new ConstantExpression(type, value);
        TypedExpression typedExpression = new TypedExpression(type, origExpression);

        // when
        boolean typedIsTyped = typedExpression.isTyped();

        // then
        assertTrue(typedIsTyped);
    }

    @Test
    public void testIsTypedNegative() {
        // given
        Class<?> type = Integer.class;
        int value = 42;
        Expression origExpression = new ConstantExpression(type, value);
        TypedExpression untypedExpression =
            new TypedExpression(de.renew.util.Types.UNTYPED, origExpression);

        // when
        boolean untypedIsTyped = untypedExpression.isTyped();

        // then
        assertFalse(untypedIsTyped);
    }
}
