package de.renew.formalism.function;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;

public class DynamicMethodFunctionTest {
    @Test
    public void testDoFunction() throws Exception {
        //given
        var dynamicMethodFunction = new DynamicMethodFunction("toString");
        final String one = "1";
        var value = Integer.valueOf(one);
        //when
        final var actual = dynamicMethodFunction.doFunction(value, new Object[] { });
        //then
        assertEquals(one, actual);
    }

    @Test
    public void testToString() {
        //given
        var dynamicMethodFunction = new DynamicMethodFunction("toString");
        var actual = dynamicMethodFunction.toString();
        //when
        final var expected = "DynamicMethodFunc: untyped.toString<unknown parameters>";
        //then
        assertEquals(expected, actual);
    }
}
