package de.renew.formalism;

import org.junit.jupiter.api.Test;

import static de.renew.formalism.java.LiteralParser.denotesDigit;
import static de.renew.formalism.java.LiteralParser.denotesFloat;
import static de.renew.formalism.java.LiteralParser.denotesHexDigit;
import static de.renew.formalism.java.LiteralParser.denotesLong;
import static de.renew.formalism.java.LiteralParser.parseChar;
import static de.renew.formalism.java.LiteralParser.parseDouble;
import static de.renew.formalism.java.LiteralParser.parseFloat;
import static de.renew.formalism.java.LiteralParser.parseInt;
import static de.renew.formalism.java.LiteralParser.parseLong;
import static de.renew.formalism.java.LiteralParser.parseString;
import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;

class LiteralParserTest {

    @Test
    void testDenotesLong() {
        //given
        String testString = "14l";
        String testString1 = "14";

        //when
        boolean testLong = denotesLong(testString);
        boolean testLong1 = denotesLong(testString1);

        //then
        assertTrue(testLong);
        assertFalse(testLong1);


    }

    @Test
    void testDenotesFloat() {
        //given
        String testString = "14.4f";
        String testString1 = "14.4";

        //when
        boolean testFloat = denotesFloat(testString);
        boolean testFloat1 = denotesFloat(testString1);

        //then
        assertTrue(testFloat);
        assertFalse(testFloat1);
    }

    @Test
    void testParseDouble() {
        //given
        String testString = "14.4d";
        String testString1 = "14.4";

        //when
        Double testDouble = parseDouble(testString);
        Double testDouble1 = parseDouble(testString1);

        //then
        assertEquals(14.4, testDouble);
        assertEquals(14.4, testDouble1);

    }

    @Test
    void testParseFloat() {
        //given
        String testString = "14.4f";
        String testString1 = "14.4";

        //when
        Float testFloat = parseFloat(testString);
        Float testFloat1 = parseFloat(testString1);

        //then
        assertEquals((float) 14.4, testFloat);
        assertEquals((float) 14.4, testFloat1);
    }

    @Test
    void testParseLong() {
        //given
        String testString = "14l";
        String testString1 = "1";
        String testString2 = "014";

        //when
        long testLong = parseLong(testString);
        long testLong1 = parseLong(testString1);
        long testLong2 = parseLong(testString2);

        //then
        assertEquals(14, testLong);
        assertEquals(1, testLong1);
        assertEquals(12, testLong2);

    }

    @Test
    void testParseInt() {
        //given
        String testString = "14l";
        String testString1 = "1";
        String testString2 = "014";

        //when
        int testInt = parseInt(testString);
        int testInt1 = parseInt(testString1);
        int testInt2 = parseInt(testString2);

        //then
        assertEquals(14, testInt);
        assertEquals(1, testInt1);
        assertEquals(12, testInt2);
    }

    @Test
    void testDenotesDigit() {
        //given
        char testChar = '0';
        char testChar1 = '9';
        char testChar2 = 'a';

        //when
        boolean testDigit = denotesDigit(testChar);
        boolean testDigit1 = denotesDigit(testChar1);
        boolean testDigit2 = denotesDigit(testChar2);

        //then
        assertTrue(testDigit);
        assertTrue(testDigit1);
        assertFalse(testDigit2);
    }

    @Test
    void testDenotesHexDigit() {
        //given
        char testChar = '0';
        char testChar1 = '7';
        char testChar2 = '9';

        //when
        boolean testHexDigit = denotesHexDigit(testChar);
        boolean testHexDigit1 = denotesHexDigit(testChar1);
        boolean testHexDigit2 = denotesHexDigit(testChar2);

        //then
        assertTrue(testHexDigit);
        assertTrue(testHexDigit1);
        assertFalse(testHexDigit2);
    }

    @Test
    void testParseString() {
        //given
        String testString = ".14.";
        String testString1 = ".\\46\\44.";
        String testString2 = ".1\n4.";
        String testString3 = ".1\t4.";
        String testString4 = ".1\b4.";

        //when
        String testParseString = parseString(testString);
        String testParseString1 = parseString(testString1);
        String testParseString2 = parseString(testString2);
        String testParseString3 = parseString(testString3);
        String testParseString4 = parseString(testString4);

        //then
        assertEquals("14", testParseString);
        assertEquals("&$", testParseString1);
        assertEquals("1\n4", testParseString2);
        assertEquals("1\t4", testParseString3);
        assertEquals("1\b4", testParseString4);

    }

    @Test
    void testParseChar() {
        //given
        String testString = ".14.";
        String testString1 = ".\\46\\44.";
        String testString2 = ".1\n4.";

        //when
        char testParseChar = parseChar(testString);
        char testParseChar1 = parseChar(testString1);
        char testParseChar2 = parseChar(testString2);

        //then
        assertEquals('1', testParseChar);
        assertEquals('&', testParseChar1);
        assertEquals('1', testParseChar2);
    }
}