package de.renew.formalism.java;


/**
 * Stores a value for the type of a place to transfer the value
 * from a shadow net inscription to the compiled
 * {@link de.renew.net.Place} object. The valid values are
 * defined as integer constant definition in the <code>Place</code>
 * class.
 * PlaceBehaviourModifier.java
 * Created: Wed Mar 21  2001
 * @author Michael Duvigneau
 */

/**
 * Represents the behaviour type for a place.
 */
public class PlaceBehaviourModifier {
    public final int _behaviour;

    /**
     * Constructor to set the behaviour value.
     * @param behaviour the behaviour type for the place
     */
    public PlaceBehaviourModifier(int behaviour) {
        this._behaviour = behaviour;
    }
}