package de.renew.formalism.java;

/**
 * Class for ChannelInscription
 * Stores upLink, name and arity and provides hash and equals-function
 * Used by Parsers to get ChannelInscitpion Object
 */
public class ChannelInscription {
    /**
     * boolean if the ChannelInscription is an uplink
     */
    public final boolean _isUplink;
    /**
     * name of Inscription
     */
    public final String _name;
    /**
     * Arity(Amount of arguments)
     */
    public final int _arity;
    private final int _hash;

    /**
     * Constructor
     * @param isUplink Wether the ChannelInscription is an uplink
     * @param name the name
     * @param arity the arity
     */
    public ChannelInscription(boolean isUplink, String name, int arity) {
        this._isUplink = isUplink;
        this._name = name.intern();
        this._arity = arity;
        _hash = name.hashCode() + arity * 135 + (isUplink ? 137 : 0);
    }

    @Override
    public int hashCode() {
        return _hash;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ChannelInscription)) {
            return false;
        }
        ChannelInscription that = (ChannelInscription) o;
        return _isUplink == that._isUplink && _name.equals(that._name) && _arity == that._arity;
    }
}