package de.renew.formalism.bool;

import java.util.HashSet;
import java.util.Set;

import de.renew.expression.LocalVariable;


/**
 * Class to keep track of all created local Variables.
 */
public class LocalVariableSet {
    private final Set<LocalVariable> _known = new HashSet<>();

    /**
     * Creates a local variable and stores it in the set.
     * If a known variable has the same name, the name becomes name'
     *
     * @param name the name of the variable
     * @return A LocalVariable with the variables name
     */
    public LocalVariable create(String name) {
        do {
            LocalVariable var = new LocalVariable(name);
            if (_known.contains(var)) {
                name = name + "'";
            } else {
                _known.add(var);
                return var;
            }
        } while (true);
    }
}