# Formalism

## User Guide

_Formalism_ provides support for multiple net compilers.

### Features

- `ShadowCompilerFactory` objects will be used to create compilers.
- The factories can be registered by the `FormalismPlugin` instance via the `addCompilerFactory` method.
- A set of standard compilers is provided:
  - Java Net Compiler
  - Bool Net Compiler
  - P/T Net Compiler
  - Timed Java Compiler

### Example Usage

1. Open a net in Renew.
2. Use command line commands to list and choose the available formalisms.
3. Simulate the net with the connected compiler in the Renew window by pressing `Strg + R`.

### Provided Commands

<!-- Use the classes implementing CLCommand. The 'help' output of the command can be a useful description -->

- `listFormalisms` - Displays a list of all available formalisms
- `setFormalism <name>` - Sets the named formalism

### Installation

Install _Formalism_ by putting the JAR file inside the `dist/plugins` directory.

It will be automatically loaded at startup of Renew - see below for more configuration options.

### Dependencies

This plugin depends on the following plugins and external libraries:

<!-- must match the `module-info.java` -->

- `Simulator`: simulation engine
- `log4j`: Logging framework

### Configuration

During the initialization of Formalism, the following property is read:

**NAME**|**TYPE**|**DESCRIPTION**|**DEFAULT VALUE**
:-----|:-----:|:-----:|:-----
`renew.compiler`|`String`|The compiler that will become active as soon as its factory is known.|Java Net Compiler

## Developer Guide

### Core Class

- `FormalismPlugin`: Provides an administration facility to the several compilers.

### How to Extend

_Formalism_ exposes the following Interface:

- `de.renew.formalism.FormalismChangeListener` - Components may register themselves as `FormalismChangeListeners`. They will be notified if formalisms are added or removed or if the current compiler changes.

The Java Compiler implementation within _Formalism_ exposes the following three Interfaces:

- `de.renew.formalism.java.ArcFactory`
- `de.renew.formalism.java.ArcInscription` - this interface tags objects that may be inscribed to an arc
- `de.renew.formalism.java.InscriptionParser`

When changing the `JavaNetParser.jj` (even just changing comments), the changes have to be merged to the `Distribute` and `Catch` plugins.
This can be done by simply running `ant dep.merge` in their directories.
For further information, see their respective build.xml files.

### Additional Information

<!-- Common issues, explanations for inconsistencies, etc. -->

One compiler is always active at a time. This can be configured by the `setCompiler` method of FormalismPlugin.
If a compiler is set active but is not present in the system, the choice will be
stored and the compiler will be chosen as soon as it is registered.