package de.uni_hamburg.fs;

/**
 * Exception thrown when unification of two types fails in a feature structure.
 * This typically occurs when attempting to combine incompatible types.
 */
public class UnificationFailure extends Exception {
    /**
     * Constructs a new UnificationFailure with no detail message.
     */
    public UnificationFailure() {
        super();
    }

    /**
     * Constructs a new UnificationFailure with the specified cause.
     *
     * @param cause the cause of the unification failure
     */
    public UnificationFailure(Throwable cause) {
        super(cause);
    }

    /**
     * Constructs a new UnificationFailure with the specified detail message and cause.
     *
     * @param message the detail message
     * @param cause the cause of the unification failure
     */
    public UnificationFailure(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a new UnificationFailure with a message indicating that two types are incompatible.
     *
     * @param t1 the first type that failed to unify
     * @param t2 the second type that failed to unify
     */
    public UnificationFailure(Type t1, Type t2) {
        super("Types " + t1 + " and " + t2 + " are not compatible.");
    }
}