package de.uni_hamburg.fs;

import collections.CollectionEnumeration;


/**
 * Represents a node in a feature structure that contains no features.
 * This implementation is used for nodes that do not have any feature-value pairs.
 */
public class NoFeatureNode extends AbstractNode {
    //  private int hashCode;

    /**
     * Constructs a new NoFeatureNode with the specified node type.
     *
     * @param nodetype the type of the node to be created
     */
    public NoFeatureNode(Type nodetype) {
        super(nodetype);


        //    if (nodetype.isExtensional())
        //      hashCode=3*nodetype.hashCode();
        //    else
        //      hashCode=super.hashCode();
    }

    /**
     * Constructs a new NoFeatureNode with the TOP type.
     * This is a convenience constructor that creates a node with the most general type.
     */
    public NoFeatureNode() {
        this(Type.TOP);
    }

    /*
      public int hashCode() {
        return hashCode;
      }
    
      public boolean equals(Object that) {
        if (that instanceof NoFeatureNode) {
          if (nodetype.isExtensional() &&
        nodetype.equals(((NoFeatureNode)that).nodetype))
          return true;
        }
        return super.equals(that);
      }
    */
    @Override
    public CollectionEnumeration featureNames() {
        return EmptyEnumeration.INSTANCE;
    }

    @Override
    public boolean hasFeature(Name featureName) {
        return false;
    }

    @Override
    public Node delta(Name featureName) throws NoSuchFeatureException {
        throw new NoSuchFeatureException(featureName, _nodetype);
    }

    /**
     * Sets the value of the feature with the given name.
     * This method should only be called during construction of
     * a Node.
     */
    @Override
    public void setFeature(Name featureName, Node value) {
        throw new NoSuchFeatureException(featureName, _nodetype);
    }

    @Override
    public Node duplicate() {
        if (_nodetype.isExtensional()) {
            return this;
        }
        return new NoFeatureNode(_nodetype);
    }
}