package de.uni_hamburg.fs;

import java.util.NoSuchElementException;

import collections.CollectionEnumeration;


/**
 * An implementation of CollectionEnumeration that represents an empty enumeration
 * with no elements. This class provides a singleton instance and methods to check
 * for elements, retrieve elements, and get information about the enumeration's state.
 */
public class EmptyEnumeration implements CollectionEnumeration {
    /**
     * Singleton instance of EmptyEnumeration for reuse.
     */
    public final static EmptyEnumeration INSTANCE = new EmptyEnumeration();

    /**
     * Constructs a new empty enumeration.
     */
    public EmptyEnumeration() {}

    @Override
    public boolean hasMoreElements() {
        return false;
    }

    @Override
    public Object nextElement() throws NoSuchElementException {
        throw new NoSuchElementException();
    }

    @Override
    public boolean corrupted() {
        return false;
    }

    @Override
    public int numberOfRemainingElements() {
        return 0;
    }
}