package de.renew.gui.fs;

import CH.ifa.draw.util.CommandMenu;


/**
 * This class configures the Renew user interface when the EFS Net Compiler is
 * chosen.
 * Created: Fri Aug 12  2005
 * @author Michael Duvigneau
 **/
public class EFSGuiConfigurator extends FSGuiConfigurator {
    /**
     * Menu ID of EFS-Semantics entry.
     */
    protected static final String MENU_ID_EFSSEMANTICS = "de.renew.gui.fs.efssemantics";

    /**
     * Registers formalism-specific entries in the attributes menu.
     **/
    @Override
    protected void addFSOptions(CommandMenu optionsMenu) {
        super.addFSOptions(optionsMenu);
        CommandMenu semanticsMenu = new CommandMenu("Semantics");
        semanticsMenu.add(new SetEFSNetSemanticsCommand("Reference", false));
        semanticsMenu.add(new SetEFSNetSemanticsCommand("Value", true));
        optionsMenu.add(semanticsMenu);
    }
}