package de.renew.formalism.fsnet;

import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import de.renew.net.NetInstance;


/**
 * Class needed for an BDI example using FSNets by Frank Wienberg (in his dissertation models directory).
 */
public class ItemListenerFSNet extends EventListenerFSNet implements ItemListener {
    public ItemListenerFSNet() {}

    public ItemListenerFSNet(NetInstance instance) {
        super(instance);
    }

    public ItemListenerFSNet(NetInstance instance, ItemSelectable component) {
        this(instance);
        setComponent(component);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        eventOccured(event);
    }

    public void setComponent(Object comp) {
        if (_myComponent instanceof ItemSelectable) {
            ((ItemSelectable) _myComponent).removeItemListener(this);
        }
        _myComponent = comp;
        if (_myComponent instanceof ItemSelectable) {
            ((ItemSelectable) _myComponent).addItemListener(this);
        }
    }
}