package de.renew.formalism.fsnet;

import de.renew.net.Net;
import de.renew.net.NetInstanceImpl;
import de.renew.net.NetLookup;
import de.renew.simulator.api.SimulationManager;
import de.renew.simulatorontology.loading.NetNotFoundException;
import de.renew.unify.Impossible;


public class FSNetInstance extends NetInstanceImpl {
    public FSNetInstance() {
        super();
    }

    public String getOf() {
        return getNet().getName();
    }

    public void setOf(String netName) {
        try {
            Net net = new NetLookup().findForName(netName);
            initNet(net, true);
            createConfirmation(SimulationManager.getCurrentSimulator().currentStepIdentifier());
        } catch (NetNotFoundException e) {
            throw new RuntimeException("Could not make an FSNet instance: " + e);
        } catch (Impossible e) {
            throw new RuntimeException("Could not make an FSNet instance.");
        }
    }
}