package de.renew.formalism.fsnet;

import java.awt.Button;
import java.awt.List;
import java.awt.MenuItem;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import de.renew.net.NetInstance;


/**
 * Class needed for an BDI example using FSNets by Frank Wienberg (in his dissertation models directory).
 */
public class ActionListenerFSNet extends EventListenerFSNet implements ActionListener {
    public ActionListenerFSNet() {}

    public ActionListenerFSNet(NetInstance instance) {
        super(instance);
    }

    public ActionListenerFSNet(NetInstance instance, Object component) {
        this(instance);
        setComponent(component);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        eventOccured(event);
    }

    public void setComponent(Object comp) {
        if (_myComponent != null) {
            // remove old listener:
            if (_myComponent instanceof Button) {
                ((Button) _myComponent).removeActionListener(this);
            } else if (_myComponent instanceof List) {
                ((List) _myComponent).removeActionListener(this);
            } else if (_myComponent instanceof MenuItem) {
                ((MenuItem) _myComponent).removeActionListener(this);
            } else if (_myComponent instanceof TextField) {
                ((TextField) _myComponent).removeActionListener(this);
            }
        }
        _myComponent = comp;
        if (comp instanceof Button) {
            ((Button) comp).addActionListener(this);
        } else if (comp instanceof List) {
            ((List) comp).addActionListener(this);
        } else if (comp instanceof MenuItem) {
            ((MenuItem) comp).addActionListener(this);
        } else if (comp instanceof TextField) {
            ((TextField) comp).addActionListener(this);
        }
    }
}