package de.renew.formalism.fs;

import de.renew.expression.Expression;
import de.renew.formalism.java.SimpleArcFactory;
import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.net.inscription.arc.Arc;


/**
 * ArcFactory's used in the context of FS
 */
public class FSArcFactory extends SimpleArcFactory {

    /**
     * Creates an instance of FSArcFactory with arc type and time setting.
     *
     * @param arcType the type of this arc
     * @param allowTime Whether this arc allows timed inscriptions.
     */
    public FSArcFactory(Arc.Type arcType, boolean allowTime) {
        super(arcType, allowTime);
    }

    @Override
    protected Arc getArc(
        Place place, Transition transition, Arc.Type arcType, Expression expr, Expression timeExpr)
    {
        return new FSArc(place, transition, arcType, expr, timeExpr);
    }
}