package de.renew.faformalism.util;

import org.junit.Test;

import static org.junit.jupiter.api.Assertions.assertAll;
import static org.junit.jupiter.api.Assertions.assertEquals;

public class StackDataStructureTest {

    @Test
    public void testPush() {
        //Given
        StackDataStructure stack = new StackDataStructure();
        //When
        stack.push('a');
        stack.push('b');
        //Then
        assertEquals('b', stack.peek());
    }

    @Test
    public void testPop() {
        //Given
        StackDataStructure stack = new StackDataStructure();
        //When
        stack.push('a');
        stack.push('b');
        //Then
        assertAll(
            () -> assertEquals('b', stack.pop()), () -> assertEquals('a', stack.pop()),
            () -> assertEquals(' ', stack.pop()));

    }

    @Test
    public void testPeek() {
        //Given
        StackDataStructure stack = new StackDataStructure();
        //When
        stack.push('a');
        stack.push('b');
        //Then
        assertEquals('b', stack.peek());
    }

    @Test
    public void testPeekOnEmptyStack() {
        //Given
        StackDataStructure stack = new StackDataStructure();
        //When
        stack.pop();
        //Then
        assertEquals(' ', stack.peek());
    }
}
