package de.renew.faformalism.util;

import java.util.Stack;

/**
 * This class implements the automaton stack as an individual data structure.
 * This implementation is used for the simulation of PDAs.
 */
public class StackDataStructure implements AutomatonDataStructure, Cloneable {

    private Stack<Character> _internalStack;

    /**
     * Initialises a new stack.
     */
    public StackDataStructure() {
        _internalStack = new Stack<Character>();
    }

    /**
     * Pushes the given item onto the top of this stack.
     * @param c item to be pushed
     */
    public void push(char c) {
        _internalStack.push(c);
    }

    /**
     * Removes the item on top of the stack.
     * @return removed item (' ' if stack is empty).
     */
    public char pop() {
        if (_internalStack.isEmpty()) {
            return ' ';
        } else {
            char r = _internalStack.peek();
            _internalStack.pop();
            return r;
        }
    }

    /**
     * Looks at the object at the top of this stack without removing it.
     * @return item on top of the stack (' ' if the stack is empty).
     */
    public char peek() {
        if (_internalStack.isEmpty()) {
            return ' ';
        } else {
            return _internalStack.peek();
        }
    }

    @Override
    public String toString() {
        return _internalStack.toString();
    }

    @Override
    public Object clone() {
        StackDataStructure copy = new StackDataStructure();
        copy._internalStack = (Stack<Character>) _internalStack.clone();
        return copy;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof StackDataStructure)) {
            return false;
        }
        return _internalStack.equals(((StackDataStructure) other)._internalStack);
    }

    @Override
    public int hashCode() {
        return _internalStack.hashCode();
    }
}
