package de.renew.faformalism;

import java.net.URL;

import de.renew.faformalism.compiler.FAAutomatonCompiler;
import de.renew.faformalism.compiler.FANetCompiler;
import de.renew.formalism.FormalismPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginProperties;


/**
 * The wrapper for the FAFormalism Plugin.
 * Provides FANetCompiler and FAAutomatonCompiler formalisms.
 * Enables the simulation of automaton drawn with the FA plugin.
 *
 * @author Pascale Möller, Karl Ihlenfeldt
 * @version 3.0
 */
public class FAFormalismPlugin extends PluginAdapter {
    private final static org.apache.log4j.Logger LOGGER =
        org.apache.log4j.Logger.getLogger(FAFormalismPlugin.class);

    public final static String FA_NET_COMPILER_NAME = "FA Net Compiler";

    public final static String FA_AUTOMATON_COMPILER_NAME = "FA Automaton Compiler";

    public FAFormalismPlugin(URL url) throws PluginException {
        super(url);
    }

    public FAFormalismPlugin(PluginProperties props) {
        super(props);
    }

    @Override
    public void init() {
        // register the FA compiler in the compiler store
        FormalismPlugin fp = FormalismPlugin.getCurrent();
        if (fp != null) {
            fp.addCompilerFactory(FA_NET_COMPILER_NAME, new FANetCompiler());
            fp.addCompilerFactory(FA_AUTOMATON_COMPILER_NAME, new FAAutomatonCompiler());
        }
        LOGGER.debug("FA Compiler factories added");
    }

    @Override
    public boolean cleanup() {
        FormalismPlugin fp = FormalismPlugin.getCurrent();
        if (fp != null) {
            fp.removeCompilerFactory(FA_NET_COMPILER_NAME);
            fp.removeCompilerFactory(FA_AUTOMATON_COMPILER_NAME);
        }
        return super.cleanup();
    }
}