/*
 * Created on Sep 15, 2005
 *
 */

package de.renew.fa.service;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.fa.XFAFileFilter;
import de.renew.ioontology.importing.ImportFormat;
import de.renew.ioontology.importing.ImportFormatAbstract;
import de.renew.util.StringUtil;


/**
 * Defines the import XFA format for a finite automata drawing (<code>FADrawing</code>).
 * {@link de.renew.fa.service.XFAFormat}
 * @author cabac
 *
 */
public class XFAImportFormat extends ImportFormatAbstract<Drawing>
    implements ImportFormat<Drawing>
{
    /**
     * Creates an import XFAImportFormat to be used in the UI.
     */
    public XFAImportFormat() { //String name, FileFilter fileFilter) {
        super("XFA", new XFAFileFilter());
    }

    /**
     * Returns a list of all drawings in the file.
     *
     * @param file - The XFA file to be imported.
     * @return list of all imported drawings.
     * @throws Exception
     *             is thrown in case of failure during import of file.
     */
    protected List<Drawing> importFile(URL file) throws Exception {
        if (file == null) {
            return Collections.emptyList();
        }

        FileInputStream stream = new FileInputStream(new File(file.getFile()));
        XFAFormat format = new XFAFormat();
        List<Drawing> result = format.parse(stream, StringUtil.getFilename(file.getPath()));
        stream.close();
        return result;
    }

    @Override
    public List<Drawing> importFiles(URL[] paths) throws Exception {
        List<Drawing> list = new ArrayList<Drawing>(paths.length);
        for (int i = 0; i < paths.length; i++) {
            URL url = paths[i];
            list.addAll(importFile(url));
        }
        return list;
    }
}