package de.renew.fa.service;

import java.io.File;
import java.io.FileOutputStream;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.exporting.AbstractDrawingExportFormat;
import de.renew.fa.FADrawing;
import de.renew.fa.JflapFileFilter;


/**
 * Defines the export XFA format for a finite automata drawing (<code>FADrawing</code>).
 * {@link de.renew.fa.service.XFAFormat}
 * @author Cabac
 *
 */
public class JflapExportFormat extends AbstractDrawingExportFormat {
    /**
     * Creates an export JFlapExportFormat to be used in the UI.
     */
    public JflapExportFormat() {
        super("JFLAP", new JflapFileFilter());

    }

    @Override
    public boolean canExportDrawing(Drawing drawing) {
        boolean result = false;
        if (drawing instanceof FADrawing) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean canExportNto1() {
        return false;
    }

    @Override
    public File export(Drawing drawing, File path) throws Exception {
        File result = null;
        if (drawing != null && path != null) {
            result = path;
            FileOutputStream stream = new FileOutputStream(result);

            JflapFileCreator.writeToJflap(stream, drawing);
        }
        assert (result != null) : "Failure in JflapExportFormat: result == null";
        return result;
    }

    @Override
    public File export(Drawing[] drawings, File path) throws Exception {
        File file = null;
        for (int i = 0; i < drawings.length; i++) {
            file = export(drawings[i], path);
        }
        return file;
    }
}