/*
 * @(#)StartDecoration.java
 *
 */

package de.renew.fa.figures;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;

import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.Geom;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;

/**
 * A basic class for start and end decorations.
 *
 */
public class StartEndDecoration implements FigureDecoration {
    private static final int DEFAULT_SIZE = 20;
    static final long serialVersionUID = -4435677979638813780L;

    /**
     * Gets the default size of the decoration.
     *
     * @return The default size.
     */
    public static int getDefaultSize() {
        return DEFAULT_SIZE;
    }

    /**
     * Not in use.
     */
    protected int _halfSize;
    /**
     * Not in use.
     */
    protected int _size;

    /**
     * Default constructor.
     */
    public StartEndDecoration() {}

    @Override
    public void draw(Graphics g, Rectangle r, Color fillColor, Color lineColor) {
        if (FADrawMode.getInstance().getMode() == FADrawMode.STANDARD) {
            drawStandard(g, r, fillColor, lineColor);
        } else {
            //NOTICEsignature
            drawAlternative(g, r, fillColor, lineColor);
        }
    }

    /**
     * Draws the Decoration. The two points describe a rectangle, which is the
     * bounding box of the diamond.
     *
     * @param g The graphics object to draw on.
     * @param r The shape to draw.
     * @param fillColor The main color of the shape.
     * @param lineColor The outline color of the shape.
     */
    public void drawStandard(Graphics g, Rectangle r, Color fillColor, Color lineColor) {
        if (!ColorMap.isTransparent(lineColor)) {
            g.setColor(lineColor);
            g.fillArc(r.x, r.y, (r.width - 1), r.height - 1, 120, 120);
            g.fillArc(r.x, r.y, (r.width), r.height, 60, -120);
            if (!ColorMap.isTransparent(fillColor)) {
                g.setColor(fillColor);
            } else {
                // FIXME: We should erase the unneeded parts instead of
                //        painting them white
                g.setColor(Color.WHITE);
            }
            g.fillRect(
                getXabs(r) + r.width / 4, getYabs(r) + 2, Double.valueOf(r.width / 2).intValue(),
                Double.valueOf(getYprime(r) * 2).intValue() - 1);
        }
    }

    /**
     * Draws the alternative decoration.
     *
     * @param g The graphics object to draw on.
     * @param r The shape to draw.
     * @param fillColor The main color of the shape.
     * @param lineColor The outline color of the shape.
     */
    //NOTICEsignature
    public void drawAlternative(Graphics g, Rectangle r, Color fillColor, Color lineColor) {
        if (!ColorMap.isTransparent(lineColor)) {
            g.setColor(lineColor);
            int size = 5;
            int[] xPoints = new int[size];
            int[] yPoints = new int[size];
            xPoints[0] = r.x;
            yPoints[0] = r.y;
            Point p = Geom.ovalAngleToPoint(r, 3.141 * 5 / 4);
            p.translate(-1, -1);
            xPoints[1] = p.x;
            yPoints[1] = p.y;

            xPoints[2] = p.x - 8;
            yPoints[2] = p.y + 2;

            xPoints[3] = p.x + 2;
            yPoints[3] = p.y - 8;
            xPoints[4] = p.x;
            yPoints[4] = p.y;

            g.drawPolyline(xPoints, yPoints, size);
            g.drawOval(r.x + 3, r.y + 3, r.width - 6, r.height - 6);
        }
    }

    @Override
    public boolean equals(FigureDecoration fd) {
        return fd instanceof StartEndDecoration;
    }

    /**
     * Gets the X coordinate of the upper left corner of the input.
     *
     * @param r A rectangle object.
     * @return The position of the rectangle on the X-Axis.
     */
    private int getXabs(Rectangle r) {
        //float a = r.width / 2;
        return r.x;
    }

    /**
     * Returns slightly more than the input's height.
     *
     * @param r A rectangle object.
     * @return absolute Y value.
     */
    private int getYabs(Rectangle r) {
        //float a = r.width / 2;
        float b = r.height / 2;

        return Double.valueOf(r.y + b - getYprime(r)).intValue();
    }

    /**
     * Returns slightly less than half of the rectangles height.
     *
     * @param r A rectangle object.
     * @return Y-prime
     */
    private double getYprime(Rectangle r) {
        //float a = r.width / 2;
        float b = r.height / 2;
        return Math.sqrt(((1 - (.25)) * b * b));
    }

    /**
     * Reads the arrow tip from a StorableInput.
     *
     * Not currently used.
     */
    @Override
    public void read(StorableInput dr) throws IOException {
        //        _size = dr.readInt();
        //        _halfSize = dr.readInt();
        //         if (dr.getVersion() >= 5) {
        //             fAngle = dr.readDouble();
        //             fOuterRadius = dr.readDouble();
        //             fInnerRadius = dr.readDouble();
        //             fFilled = dr.readBoolean();
        //        }
    }

    /**
     * Stores the arrow tip to a StorableOutput.
     *
     * Not currently used.
     */
    @Override
    public void write(StorableOutput dw) {
        //        dw.writeInt(_size);
        //        dw.writeInt(_halfSize);
        //         dw.writeDouble(fAngle);
        //         dw.writeDouble(fOuterRadius);
        //         dw.writeDouble(fInnerRadius);
        //         dw.writeBoolean(fFilled);
    }
}