/*
 * @(#)FigureDecoration.java
 *
 */

package de.renew.fa.figures;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;

import de.renew.draw.storables.ontology.Storable;

/**
 * Decorate the start or end point of a line or poly line figure. LineDecoration
 * is the base class for the different line decorations.
 *
 * @see CH.ifa.draw.figures.PolyLineFigure
 */
public interface FigureDecoration extends Storable, Cloneable, Serializable {

    /**
     * Draws the decoration in the direction specified by the two points.
     *
     * @param g The graphics object to draw on.
     * @param r The points to specify the direction.
     * @param fillColor The main color of the shape.
     * @param lineColor The outline color of the shape.
     */
    public abstract void draw(Graphics g, Rectangle r, Color fillColor, Color lineColor);


    /**
     * Checks if this FigureDecoration object equals another.
     *
     * @param fd The FigureDecoration object to compare to.
     * @return true if they are equal, false otherwise
     */
    public boolean equals(FigureDecoration fd);
}