package de.renew.fa.figures;

import java.awt.Color;
import java.awt.Font;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ParentFigure;

/**
 * Instances of this class can be added to {@link FAStateFigure}s that are start states.
 * They represent the word the automaton will simulate.
 */
public class FAWordTextFigure extends TextFigure {

    private static final int DEFAULT_FONT = Font.ITALIC | Font.BOLD; //= 3 (base10) = 11 (base2)
    /**
     * The color of the text of this text.
     */
    private static final Color COLOR = new Color(2, 91, 255);

    /**
     * Constructs a new FAWordTextFigure with a default text.
     */
    public FAWordTextFigure() {
        this("");
    }

    /**
     * Constructs a new FAWordTextFigure with the given text as default text.
     *
     * @param text The default text for the text field
     */
    public FAWordTextFigure(String text) {
        super(text);
        setAttribute("FontStyle", DEFAULT_FONT);
        setAttribute("TextColor", COLOR);
    }

    /**
     * Checks whether a figure can be the parent of this word.
     * @param figure the figure that is to be tested.
     * @return true, if the figure is a {@link FAStateFigure} that is a StartFigure, and does not already have a word attached to it.
     */
    @Override
    public boolean canBeParent(ParentFigure figure) {
        return ((figure instanceof FAStateFigure state) && (state.isStartState()))
            || (figure instanceof FAStateInstanceFigure || figure == null);
    }

    /**
     * Sets the figure's color to the predefined color that is displayed when editing an FADrawing.
     */
    public void setNormalColor() {
        super.setTextColor(COLOR);
    }

    /**
     * Sets the figure's color to the predefined color that is displayed when simulating an automaton.
     */
    public void setColorForSimulation() {
        super.setTextColor(new Color(101, 101, 101));
    }
}
