package de.renew.fa.commands;

import java.util.Objects;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.util.Command;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.fa.figures.FADrawMode;


/**
 * The command that is executed to toggle between international or Jantzen drawing style.
 *
 * @author Lawrence Cabac
 */
public class ChangeFADrawModeCommand extends Command {

    /**
     * Creates a command to toggle between drawing styles.
     *
     */
    public ChangeFADrawModeCommand() {
        super("FA toggle mode");

    }

    /**
     * Shows the Net Components Tools Palette.
     * {@link Command#execute()}
     */
    @Override
    public void execute() {
        FADrawMode mode = FADrawMode.getInstance();
        mode.setMode(1 - mode.getMode());
        DrawingEditor editor = Objects.requireNonNull(DrawPlugin.getCurrent()).getDrawingEditor();
        FigureEnumeration en = editor.drawing().figures();
        while (en.hasMoreElements()) {
            Figure fig = en.nextFigure();
            //System.out.println("========= figure "+fig);
            fig.changed();
        }
        editor.view().checkDamage();
    }
}