<!-- Adapted from: https://www.writethedocs.org/guide/writing/beginners-guide-to-docs/ -->

# FA

## User Guide

The _FA_ plugin allows for drawing of finite automata.

### Features

- Create nets of type fa in the Renew Editor
- Use custom finite automata tools from the new UI Element
- Simulate nets using the FA Compiler-Formalism

### Example Usage

1. Open a net of type fa in the graphical editor.
2. Select the new Formalism via Simulation -> Formalism -> FANetCompiler or FAAutomatonCompiler.
3. Start the simulation. It will now run with the selected compiler.
4. You can also see the example nets in the Samples Folder.

Refer to the _FAFormalism_ guide for an explanation of the different formalisms.

### Provided Commands

<!-- Use the classes implementing CLCommand. The 'help' output of the command can be a useful description -->

_FA_ does not provide any Commands.

### Installation

Install _FA_ by putting the JAR file inside the `dist/plugins` directory.

It will be automatically loaded at startup of Renew - see below for more configuration options.

### Dependencies

This plugin depends on the following plugins and external libraries:

<!-- must match the `module-info.java` -->

- `Gui`: Add a new set of drawing tools
- `FAFormalism`: Add a new Formalism option
- `log4j`: Logging framework

### Configuration

During the initialization of _FA_, the following properties are read from the `renew.properties` file in the Renew root directory.

**NAME**|**TYPE**|**DESCRIPTION**|**DEFAULT**
:-----|:-----:|:-----|:-----
`de.renew.fa.init`|`boolean`|If true the palette is loaded on startup. If the `gui.autostart` is not set to false.|false
`de.renew.fa.mode`|`String`|If 'alternative' international style nodes are used. If 'standard' Jantzen style nodes are used.|alternative
`de.renew.fa.useindices`|`boolean`|If true appending an inscription with *index*. The inscription will have a subscript *index*.|true
`de.renew.fa.state-prefix`|`String`|Denotes the standard state name.|Z

## Developer Guide

### Core Classes

- `FAPlugin`: Extends `PluginAdapter` which Implements the `IPlugin` interface to manage the startup and shutdown.
- `FADrawing`: This Drawing is a container of arbitrary figures, but it only supports functionality for finite automaton constructs
- `PaletteCreator`: For creating the tool with international state representation

### How to Extend

_FA_ exposes multiple public Interfaces:
- `de.renew.fa.figures.FigureDecoration` - decorate the start or end point of a line or poly line figure
- `de.renew.fa.model.Arc`
- `de.renew.fa.model.FA` - model of a finite automaton
- `de.renew.fa.model.Letter`
- `de.renew.fa.model.State`
- `de.renew.fa.model.Word`
- `de.renew.fa.FAPluginExtender`

You can implement these interfaces to add additional functionality to _FA_.

### Additional Information

<!-- Common issues, explanations for inconsistencies, etc. -->

<!-- Contribution Info -->

<!-- License -->
