package de.renew.io.api;

import java.lang.reflect.Field;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import de.renew.io.impl.services.FileServiceImpl;
import de.renew.ioontology.ExtensionFileFilter;
import de.renew.ioontology.FileType;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

class FileApiTest {

    private FileServiceImpl _mockedService;

    @BeforeEach
    void setUp() throws NoSuchFieldException, IllegalAccessException {
        _mockedService = mock(FileServiceImpl.class);
        Field serviceField = FileApi.class.getDeclaredField("_service");
        serviceField.setAccessible(true);
        serviceField.set(null, _mockedService);
    }

    @AfterEach
    void tearDown() {
        _mockedService = null;
    }


    @Test
    void createExtensionFileFilter() {
        //given
        String extension = "Dummy-Extension";
        String description = "Dummy-Description";
        ExtensionFileFilter expectedFilter = mock(ExtensionFileFilter.class);
        when(_mockedService.createExtensionFileFilter(any(), any())).thenReturn(expectedFilter);

        // when
        ExtensionFileFilter actualFilter =
            FileApi.createExtensionFileFilter(extension, description);

        // then
        assertThat(actualFilter).isEqualTo(expectedFilter);
        verify(_mockedService).createExtensionFileFilter(extension, description);
    }

    @Test
    void testCreateExtensionFileFilter() {
        //given
        FileType fileType = mock(FileType.class);
        ExtensionFileFilter expectedFilter = mock(ExtensionFileFilter.class);
        when(_mockedService.createExtensionFileFilter(any())).thenReturn(expectedFilter);

        // when
        ExtensionFileFilter actualFilter = FileApi.createExtensionFileFilter(fileType);

        // then
        assertThat(actualFilter).isEqualTo(expectedFilter);
        verify(_mockedService).createExtensionFileFilter(fileType);
    }
}