package de.renew.draw.ui.impl.services;

import java.awt.Rectangle;
import java.util.Vector;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

import CH.ifa.draw.figures.ElbowHandle;
import CH.ifa.draw.figures.FontSizeHandle;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.standard.NullHandle;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.Locator;
import de.renew.draw.ui.ontology.FigureHandle;

import static org.assertj.core.api.AssertionsForClassTypes.assertThat;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

class HandleServiceImplTest {

    private HandleServiceImpl _handleService;

    @BeforeEach
    void setUp() {
        _handleService = new HandleServiceImpl();
    }

    @AfterEach
    void tearDown() {
        _handleService = null;
    }

    @ParameterizedTest
    @ValueSource(ints = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 })
    void testCreateElbowHandle(int segment) {
        //given
        Figure figure = mock(LineConnection.class);
        //when
        FigureHandle testHandle = _handleService.createElbowHandle(figure, segment);
        //then
        assertThat(testHandle).isInstanceOf(ElbowHandle.class);
    }

    @Test
    void testCreateBoxHandles() {
        //given
        Figure figure = mock(LineConnection.class);
        Rectangle displayBox = new Rectangle();
        displayBox.width = 100;
        displayBox.height = 100;
        when(figure.displayBox()).thenReturn(displayBox);
        //when
        Vector<FigureHandle> handleVector = _handleService.createBoxHandles(figure);
        //then
        assertThat(handleVector).isNotNull();
        assertThat(handleVector.size()).isEqualTo(8);
    }

    @Test
    void testCreateNullHandle() {
        //given
        Figure figure = mock(LineConnection.class);
        Locator locator = mock(Locator.class);
        //when
        FigureHandle returnedHandle = _handleService.createNullHandle(figure, locator);
        //then
        assertThat(returnedHandle).isNotNull();
        assertThat(returnedHandle).isInstanceOf(NullHandle.class);
        assertThat(returnedHandle.owner()).isEqualTo(figure);
    }

    @Test
    void testCreateFontSizeHandle() {
        //given
        Figure figure = mock(LineConnection.class);
        Locator locator = mock(Locator.class);
        //when
        FigureHandle returnedHandle = _handleService.createFontSizeHandle(figure, locator);
        //then
        assertThat(returnedHandle).isNotNull();
        assertThat(returnedHandle).isInstanceOf(FontSizeHandle.class);
        assertThat(returnedHandle.owner()).isEqualTo(figure);
    }
}