package de.renew.draw.ui.impl.services;

import java.io.File;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.IOHelper;
import CH.ifa.draw.io.SimpleFileFilter;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

class DialogServiceImplTest {
    private DialogServiceImpl _service;

    @BeforeEach
    void setUp() {
        _service = new DialogServiceImpl();
    }

    @AfterEach
    void tearDown() {
        _service = null;
    }

    @Test
    void testShowSaveFileDialog() {
        //given
        File mockedFile = Mockito.mock(File.class);
        when(mockedFile.getPath()).thenReturn("Path/to/file");

        SimpleFileFilter mockedFilter = Mockito.mock(SimpleFileFilter.class);
        when(mockedFilter.getDescription()).thenReturn("DummyFilterDescription");
        when(mockedFilter.getExtension()).thenReturn(".pdf");

        IOHelper mockedIOHelper = Mockito.mock(IOHelper.class);
        DrawPlugin mockedDrawPlugin = Mockito.mock(DrawPlugin.class);
        when(mockedDrawPlugin.getIOHelper()).thenReturn(mockedIOHelper);

        try (MockedStatic<DrawPlugin> mockedDrawPluginStatic =
            Mockito.mockStatic(DrawPlugin.class)) {

            mockedDrawPluginStatic.when(DrawPlugin::getCurrentDrawPlugin)
                .thenReturn(mockedDrawPlugin);

            //when
            _service.showSaveFileDialog(mockedFile, mockedFilter);

            //then
            mockedDrawPluginStatic.verify(DrawPlugin::getCurrentDrawPlugin);
            verify(mockedDrawPlugin).getIOHelper();
        }
    }

    @Test
    void testShowSelectFilesDialogWithFilterOnly() {
        //given
        SimpleFileFilter mockedFilter = Mockito.mock(SimpleFileFilter.class);

        IOHelper mockedIOHelper = Mockito.mock(IOHelper.class);
        DrawPlugin mockedDrawPlugin = Mockito.mock(DrawPlugin.class);
        when(mockedDrawPlugin.getIOHelper()).thenReturn(mockedIOHelper);

        try (MockedStatic<DrawPlugin> mockedDrawPluginStatic =
            Mockito.mockStatic(DrawPlugin.class)) {
            mockedDrawPluginStatic.when(DrawPlugin::getCurrentDrawPlugin)
                .thenReturn(mockedDrawPlugin);

            //when
            _service.showSelectFilesDialog(mockedFilter);

            //then
            verify(mockedIOHelper).getLoadPath(mockedFilter);
        }
    }

    @Test
    void testShowSelectFilesDialogWithFileAndFilter() {
        //given
        File mockedFile = Mockito.mock(File.class);
        SimpleFileFilter mockedFilter = Mockito.mock(SimpleFileFilter.class);

        IOHelper mockedIOHelper = Mockito.mock(IOHelper.class);
        DrawPlugin mockedDrawPlugin = Mockito.mock(DrawPlugin.class);
        when(mockedDrawPlugin.getIOHelper()).thenReturn(mockedIOHelper);

        try (MockedStatic<DrawPlugin> mockedDrawPluginStatic =
            Mockito.mockStatic(DrawPlugin.class)) {
            mockedDrawPluginStatic.when(DrawPlugin::getCurrentDrawPlugin)
                .thenReturn(mockedDrawPlugin);

            //when
            _service.showSelectFilesDialog(mockedFile, mockedFilter);

            //then
            verify(mockedIOHelper).getLoadPath(mockedFile, mockedFilter);
        }
    }

    @Test
    void testShowSelectFilesDialogWithFileFilterAndMultiSelect() {
        //given
        File mockedFile = Mockito.mock(File.class);
        SimpleFileFilter mockedFilter = Mockito.mock(SimpleFileFilter.class);
        boolean multiSelection = true;

        IOHelper mockedIOHelper = Mockito.mock(IOHelper.class);
        DrawPlugin mockedDrawPlugin = Mockito.mock(DrawPlugin.class);
        when(mockedDrawPlugin.getIOHelper()).thenReturn(mockedIOHelper);

        try (MockedStatic<DrawPlugin> mockedDrawPluginStatic =
            Mockito.mockStatic(DrawPlugin.class)) {
            mockedDrawPluginStatic.when(DrawPlugin::getCurrentDrawPlugin)
                .thenReturn(mockedDrawPlugin);

            //when
            _service.showSelectFilesDialog(mockedFile, mockedFilter, multiSelection);

            //then
            verify(mockedIOHelper).getLoadPath(mockedFile, mockedFilter, multiSelection);
        }
    }
}
