package de.renew.draw.ui.impl.dialogs.internal;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import de.renew.draw.ui.impl.dialogs.DialogCreator;
import de.renew.draw.ui.ontology.dialogs.DialogMessageType;
import de.renew.draw.ui.ontology.dialogs.InputDialog;
import de.renew.draw.ui.ontology.dialogs.InputDialogBuilder;
import de.renew.draw.ui.ontology.dialogs.MessageDialog;
import de.renew.draw.ui.ontology.dialogs.MessageDialogBuilder;
import de.renew.draw.ui.ontology.dialogs.OptionDialog;
import de.renew.draw.ui.ontology.dialogs.OptionDialogBuilder;

import static org.assertj.core.api.Assertions.assertThat;

public class DialogCreatorTest {

    private static final String TEST_TITLE = "Test Dialog";
    private static final String TEST_MESSAGE = "Test Message";
    private static final Icon TEST_ICON = new ImageIcon();
    private JFrame _parentComponent;

    @BeforeEach
    void setUp() {
        _parentComponent = new JFrame();
    }

    @Test
    void testInputDialogBuilder() {

        // given
        InputDialogBuilder builder = DialogCreator.createInputDialogBuilder();
        Object[] selectionValues = new String[] { "Option 1", "Option 2" };
        String initialValue = "Option 2";

        // when
        InputDialog dialog = builder.setParentComponent(_parentComponent).setTitle(TEST_TITLE)
            .setMessage(TEST_MESSAGE).setMessageType(DialogMessageType.QUESTION_MESSAGE)
            .setIcon(TEST_ICON).setSelectionValues(selectionValues)
            .setInitialSelectionValue(initialValue).build();

        // then
        InputDialogBuilder newBuilder = dialog.toNewBuilder();
        InputDialog rebuiltDialog = newBuilder.build();

        assertThat(dialog).isNotNull();
        assertThat(rebuiltDialog).isNotNull().isNotSameAs(dialog);

    }

    @Test
    void testMessageDialogBuilder() {

        // given
        MessageDialogBuilder builder = DialogCreator.createMessageDialogBuilder();

        // when
        MessageDialog dialog = builder.setParentComponent(_parentComponent).setTitle(TEST_TITLE)
            .setMessage(TEST_MESSAGE).setMessageType(DialogMessageType.INFORMATION_MESSAGE)
            .setIcon(TEST_ICON).build();

        // then
        MessageDialogBuilder newBuilder = dialog.toNewBuilder();
        MessageDialog rebuiltDialog = newBuilder.build();

        assertThat(dialog).isNotNull();
        assertThat(rebuiltDialog).isNotNull().isNotSameAs(dialog);

    }

    @Test
    void testOptionDialogBuilder() {

        // given
        OptionDialogBuilder builder = DialogCreator.createOptionDialogBuilder();
        Object[] options = new String[] { "Ja", "Nein", "Abbrechen" };

        // when
        OptionDialog dialog = builder.setParentComponent(_parentComponent).setTitle(TEST_TITLE)
            .setMessage(TEST_MESSAGE).setMessageType(DialogMessageType.PLAIN_MESSAGE)
            .setIcon(TEST_ICON).setSelectionValues(options).setInitialSelectionValue(options[0])
            .build();

        // then
        OptionDialogBuilder newBuilder = dialog.toNewBuilder();
        OptionDialog rebuiltDialog = newBuilder.build();

        assertThat(dialog).isNotNull();
        assertThat(rebuiltDialog).isNotNull().isNotSameAs(dialog);

    }

    @Test
    void testDialogBuilderDefaults() {

        // given
        InputDialogBuilder inputBuilder = DialogCreator.createInputDialogBuilder();
        MessageDialogBuilder messageBuilder = DialogCreator.createMessageDialogBuilder();
        OptionDialogBuilder optionBuilder = DialogCreator.createOptionDialogBuilder();

        // when
        InputDialog inputDialog = inputBuilder.build();
        MessageDialog messageDialog = messageBuilder.build();
        OptionDialog optionDialog = optionBuilder.build();

        // then
        assertThat(inputDialog).isNotNull();
        assertThat(messageDialog).isNotNull();
        assertThat(optionDialog).isNotNull();

    }

}