package de.renew.draw.ui.api;

import java.awt.Image;
import java.lang.reflect.Field;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import de.renew.draw.ui.impl.services.ImageServiceImpl;

import static org.assertj.core.api.AssertionsForClassTypes.assertThat;
import static org.mockito.Mockito.anyString;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

class ImageApiTest {
    private ImageServiceImpl _mockedService;

    @BeforeEach
    void setUp() throws NoSuchFieldException, IllegalAccessException {
        _mockedService = mock(ImageServiceImpl.class);
        Field serviceField = ImageApi.class.getDeclaredField("_imageService");
        serviceField.setAccessible(true);
        serviceField.set(null, _mockedService);
    }

    @AfterEach
    void tearDown() {
        _mockedService = null;
    }

    @Test
    void testGetImage() {
        //given
        Image image = mock(Image.class);
        when(_mockedService.getImage(anyString())).thenReturn(image);
        //when
        Image testImage = ImageApi.getImage(image.toString());
        //then
        verify(_mockedService, times(1)).getImage(image.toString());
        assertThat(testImage).isEqualTo(image);
    }

    @Test
    void testRegisterImage() {
        //given
        Image image = mock(Image.class);
        //when
        ImageApi.registerImage(image.toString());
        //then
        verify(_mockedService, times(1)).registerImage(image.toString());
    }

    @Test
    void testLoadImage() {
        //given
        Image image = mock(Image.class);
        when(_mockedService.loadImage(anyString())).thenReturn(image);
        //when
        Image testImage = ImageApi.loadImage(image.toString());
        //then
        verify(_mockedService, times(1)).loadImage(image.toString());
        assertThat(testImage).isEqualTo(image);
    }

    @Test
    void testRegisterAndLoadImage() {
        //given
        Image image = mock(Image.class);
        //when
        ImageApi.registerImage(image.toString());
        //then
        verify(_mockedService, times(1)).registerImage(image.toString());
    }

    @Test
    void testGetIconImage() {
        //given
        Image image = mock(Image.class);
        when(_mockedService.getIconImage()).thenReturn(image);
        //when
        Image resultImage = _mockedService.getIconImage();
        //then
        verify(_mockedService).getIconImage();
        assertThat(resultImage).isEqualTo(image);
    }
}