package de.renew.draw.ui.api;

import java.io.File;
import java.util.Properties;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.ui.impl.services.ApplicationServiceImpl;

import static org.assertj.core.api.AssertionsForClassTypes.assertThat;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

class ApplicationApiTest {

    private final ApplicationServiceImpl _mockedService = mock(ApplicationServiceImpl.class);

    @Test
    void testSetDrawProperties() {
        //given
        Properties properties = mock(Properties.class);
        //when
        _mockedService.setDrawProperties(properties);
        //then
        verify(_mockedService).setDrawProperties(properties);

    }

    @ParameterizedTest
    @ValueSource(booleans = { true, false })
    void testIsAvoidFrameReshape(boolean testValue) {
        //given
        when(_mockedService.isAvoidFrameReshape()).thenReturn(testValue);
        //when
        boolean actualValue = _mockedService.isAvoidFrameReshape();
        //then
        assertThat(actualValue).isEqualTo(testValue);
        verify(_mockedService).isAvoidFrameReshape();
    }

    @ParameterizedTest
    @ValueSource(booleans = { true, false })
    void testIsNoGraphics(boolean testValue) {
        //given
        when(_mockedService.isNoGraphics()).thenReturn(testValue);
        //when
        boolean actualValue = _mockedService.isNoGraphics();
        //then
        assertThat(actualValue).isEqualTo(testValue);
        verify(_mockedService).isNoGraphics();
    }

    @Test
    void testGetLastPath() {
        //given
        File file = mock(File.class);
        when(_mockedService.getLastPath()).thenReturn(file);
        //when
        File resultFile = _mockedService.getLastPath();
        //then
        verify(_mockedService).getLastPath();
        assertThat(resultFile).isEqualTo(file);
    }

    @ParameterizedTest
    @ValueSource(booleans = { true, false })
    void testCanClose(boolean value) {
        //given
        when(_mockedService.canClose()).thenReturn(value);
        //when
        boolean resultValue = _mockedService.canClose();
        //then
        verify(_mockedService).canClose();
        assertThat(resultValue).isEqualTo(value);
    }

    @Test
    void testRequestClose() {
        //given/when:
        _mockedService.requestClose();
        //then:
        verify(_mockedService).requestClose();
    }

    @Test
    void testShowStatus() {
        //given:
        String test = "test";
        //when:
        _mockedService.showStatus(test);
        //hen:
        verify(_mockedService).showStatus(test);
    }



    @Test
    void testRegisterDrawingViewFactory() {
        //given:
        Drawing dummyClass = mock(Drawing.class);
        String test = "test";
        //when:
        _mockedService.registerDrawingViewFactory(dummyClass.getClass(), test);
        //then
        verify(_mockedService).registerDrawingViewFactory(dummyClass.getClass(), test);
    }
}