package CH.ifa.draw.standard;

import org.junit.jupiter.api.Test;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.DrawingListener;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.verifyNoInteractions;


class StandardDrawingLookupTest {

    @Test
    void testAddDrawingListener() {
        //given
        StandardDrawingLookup lookupObject = new StandardDrawingLookup();
        DrawingListener dummyDrawingListener = mock(DrawingListener.class);

        //when
        lookupObject.addDrawingListener(dummyDrawingListener);

        //then
        Drawing drawing = new NullDrawing();
        lookupObject.removeViewContainer(drawing);
        verify(dummyDrawingListener).drawingReleased(drawing);
    }

    @Test
    void testRemoveDrawingListener() {
        //given
        StandardDrawingLookup lookupObject = new StandardDrawingLookup();
        DrawingListener dummyDrawingListener = mock(DrawingListener.class);
        lookupObject.addDrawingListener(dummyDrawingListener);

        //when
        lookupObject.removeDrawingListener(dummyDrawingListener);

        //then
        Drawing drawing = new NullDrawing();
        lookupObject.removeViewContainer(drawing);
        verifyNoInteractions(dummyDrawingListener);
    }
}