package CH.ifa.draw.standard;

import java.util.Collection;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;

import org.junit.jupiter.api.Test;

import static org.assertj.core.api.Assertions.assertThat;

public class EditMenuCreatorTest {

    @Test
    public void testCreateMenus() {
        //given
        final EditMenuCreator editMenuCreator = new EditMenuCreator();
        Set<String> expectedTexts = Set.of(
            "Undo", "Cut", "Group", "Redo", "Copy", "Paste", "Delete", "Duplicate", "Search...",
            "Ungroup", "Select All", "Invert Selection", "Search & Replace...");

        //when
        Collection<JMenuItem> menuItems = editMenuCreator.createMenus();

        //then
        assertThat(menuItems).isNotEmpty().map(AbstractButton::getText).containsAll(expectedTexts);

    }
}