package CH.ifa.draw.io;

import java.io.File;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import static org.assertj.core.api.AssertionsForClassTypes.assertThat;

class SVGFileFilterTest {
    private SVGFileFilter _filter;

    @BeforeEach
    public void setUp() {
        _filter = new SVGFileFilter();
    }

    /**
     * This test verifies the functionality of the .accept() method and checks if a file with the .svg extension gets accepted, as it should.
     */
    @Test
    public void testAcceptSVG() {
        //given
        File file = new File("test.svg");
        //when/then
        assertThat(_filter.accept(file)).isTrue();
    }

    /**
     * This test checks if a non-SVG-File is rejected correctly.
     */
    @Test
    public void testAcceptNotSVG() {
        //given
        File file = new File("picture.png");
        //when/then
        assertThat(_filter.accept(file)).isFalse();
    }

    /**
     * This test checks if the description of a newly created SVG-Filter matches the expected description.
     */
    @Test
    public void testGetDescription() {
        //when/then
        assertThat(_filter.getDescription()).isEqualTo("Scalable Vector Graphic");
    }
}