package CH.ifa.draw.io;

import java.io.File;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import static org.assertj.core.api.AssertionsForClassTypes.assertThat;

class PDFFileFilterTest {
    private PDFFileFilter _filter;

    @BeforeEach
    public void setUp() {
        _filter = new PDFFileFilter();
    }

    /**
     * This test verifies the functionality of the .accept() method and checks if a file with the .pdf extension gets accepted, as it should.
     */
    @Test
    public void testAcceptPDF() {
        //given
        File file = new File("test.pdf");
        //when/then
        assertThat(_filter.accept(file)).isTrue();
    }

    /**
     * This test checks if a non-PDF-File is rejected correctly.
     */
    @Test
    public void testAcceptNotPDF() {
        //given
        File file = new File("picture.png");
        //when/then
        assertThat(_filter.accept(file)).isFalse();
    }

    /**
     * This test checks if the description of a newly created PDF-Filter matches the expected description.
     */
    @Test
    public void testGetDescription() {
        //when/then
        assertThat(_filter.getDescription()).isEqualTo("Portable Document Format");
    }
}