package CH.ifa.draw.io;

import java.io.File;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import static org.assertj.core.api.AssertionsForClassTypes.assertThat;

class EPSFileFilterTest {
    private EPSFileFilter _filter;

    @BeforeEach
    public void setUp() {
        _filter = new EPSFileFilter();
    }

    /**
     * This test verifies the functionality of the .accept() method and checks if a file with the .eps extension gets accepted, as it should.
     */
    @Test
    public void testAcceptEPS() {
        //given
        File file = new File("test.eps");
        //when/then
        assertThat(_filter.accept(file)).isTrue();
    }

    /**
     * This test checks if a non-EPS-File is rejected correctly.
     */
    @Test
    public void testAcceptNotEPS() {
        //given
        File file = new File("picture.png");
        //when/then
        assertThat(_filter.accept(file)).isFalse();
    }

    /**
     * This test checks if the description of a newly created EPS-filter matches the expected description.
     */
    @Test
    public void testGetDescription() {
        //when/then
        assertThat(_filter.getDescription()).isEqualTo("Encapsulated Post Script File");
    }
}