package de.renew.ioontology.importing;


import java.util.List;

/**
 * Container for ImportFormats. Is an ImportFormat itself.
 * Can be used to arrange ImportFormats in groups.
 * @param <T> The type of the object that is the result of the import.
 */
public interface ImportFormatMulti<T> extends ImportFormat<T> {

    /**
     * Adds a format to the MultiFormat.
     * @param importFormat the format to be added to MultiFormat
     */
    void addImportFormat(ImportFormat<T> importFormat);

    /**
     * Remove a format from the MultiFormat.
     * @param importFormat the ImportFormat to be removed
     */
    void removeImportFormat(ImportFormat<T> importFormat);

    /**
     * Returns all formats in the MultiFormat.
     * @return list of all ImportFormats in MultiFormat
     */
    List<ImportFormat<T>> getImportFormats();

}