package de.renew.ioontology.exporting;

import java.util.EventListener;

/**
 * Type that allows to react to changes in the known export formats.
 * @param <T> the type of objects the export formats are related to
 */
public interface ExportFormatListener<T> extends EventListener {

    /**
     * Reaction for the addition of the given export format.
     * @param addedFormat the export format that is added
     */
    void exportFormatAdded(ExportFormat<T> addedFormat);

    /**
     * Reaction for the removal of the given export format.
     * @param removedFormat the export format that is added
     */
    void exportFormatRemoved(ExportFormat<T> removedFormat);
}
