package de.renew.ioontology.exporting;

import java.util.List;

/**
 * Interface representing a type holding export formats.
 * @param <T> the type for which the export format is applied
 */
public interface ExportFormatHolder<T> {

    /**
     * Adds an ExportFormat to Renew.
     * It is added to the known export formats.
     *
     * @param exportFormat the ExportFormat which is to be added to Renew
     */
    void addExportFormat(ExportFormat<T> exportFormat);

    /**
     * Adds the given listener to react to changes in the known export formats.
     *
     * @param listener the listener which is to be added
     */
    void addExportFormatListener(ExportFormatListener<T> listener);

    /**
     * Removes an ExportFormat from Renew.
     * It is removed from the known export formats.
     *
     * @param exportFormat the ExportFormat which is to be removed from Renew
     */
    void removeExportFormat(ExportFormat<T> exportFormat);

    /**
     * Removes the given export format listener.
     *
     * @param listener the listener which is to be removed
     */
    void removeExportFormatListener(ExportFormatListener<T> listener);

    /**
     * Returns a list that contains all ExportFormats for the holder's type added to Renew.
     * @return list containing all ExportFormats added to Renew
     */
    List<ExportFormat<T>> getExportFormats();
}