package de.renew.ioontology;

import java.io.File;

/**
 * The FileFilter interface is the base for all filter types that can be used
 * to filter files by its extension. It holds a description to add context to its implementation.
 */
public interface FileFilter extends java.io.FileFilter {

    /**
     * Whether the given file is accepted by this filter.
     *
     * @param file the File to test
     * @return true if the file is to be accepted
     */
    boolean accept(File file);

    /**
     * The description of this filter. For example: "JPG and GIF Images"
     *
     * @return the description of this filter
     */
    String getDescription();

    /**
     * Sets the text for the description of the FileFilter.
     *
     * @param description The text for the description
     */
    void setDescription(String description);

}
