package de.renew.io.api;

import de.renew.io.api.services.FileService;
import de.renew.io.impl.services.FileServiceImpl;
import de.renew.ioontology.ExtensionFileFilter;
import de.renew.ioontology.FileType;

/**
 * Class for handling files.
 * It provides services to create file filters.
 *
 * @author Clara von Bargen
 */
public final class FileApi {

    private static FileService _service;

    // The static initialization that creates the service object
    static {
        _service = new FileServiceImpl();
    }

    private FileApi() {}

    /**
     * Constructs a new ExtensionFileFilter with the given extension and description.
     * @param extension the file extension
     * @param description description of file type
     * @return the created ExtensionFileFilter
     */
    public static ExtensionFileFilter createExtensionFileFilter(
        String extension, String description)
    {
        return _service.createExtensionFileFilter(extension, description);
    }

    /**
     * Constructs a new ExtensionFileFilter with the given extension and description.
     * @param fileType the file type
     * @return the created ExtensionFileFilter
     */
    public static ExtensionFileFilter createExtensionFileFilter(FileType fileType) {
        return _service.createExtensionFileFilter(fileType);
    }

}
