package de.renew.draw.ui.ontology.dialogs;

/**
 * Dialog builder for the {@link OptionDialog}.
 */
public interface OptionDialogBuilder extends DialogBuilder<OptionDialogBuilder> {

    /**
     * Sets the available options for the user to choose from.
     * @param selectionValues Array of options to choose from
     * @return The builder instance
     */
    OptionDialogBuilder setSelectionValues(Object[] selectionValues);

    /**
     * Sets the initial selected value of the dialog.
     * @param initialSelectionValue Initial value to be select
     * @return The builder instance.
     */
    OptionDialogBuilder setInitialSelectionValue(Object initialSelectionValue);

    /**
     * Sets the option type of the dialog.
     * @param optionType DialogOptionType to be set
     * @return The builder instance
     */
    OptionDialogBuilder setOptionType(DialogOptionType optionType);

    /**
     * Builds the dialog based on the builder.
     * @return The created dialog.
     */
    OptionDialog build();

}
