package de.renew.draw.ui.ontology.dialogs;


/**
 * The MessageDialog represents a simple dialog displaying a message.
 */
public interface MessageDialog extends Dialog<MessageDialogBuilder> {

    /**
     * Open and show the dialog.
     * This is a blocking call, opening the dialog window.
     */
    void show();

    /**
     * Open and show the dialog asynchronously.
     * This is not a blocking call.
     * @param onClosed The callback to be called when the dialog is closed.
     */
    void showAsync(Runnable onClosed);

}
