package de.renew.draw.ui.ontology.dialogs;

import java.awt.Component;
import javax.swing.Icon;

/**
 * Builder of dialogs. This base builder includes common methods available in all dialog builders.
 * @param <T> Type of the sub-dialog builder
 */
public interface DialogBuilder<T extends DialogBuilder<?>> {

    /**
     * Makes the dialog use the main gui frame.
     * @return The builder instance
     */
    T useGuiFrame();

    /**
     * Sets the parent component for the dialog.
     * @param parentComponent the parent component
     * @return The builder instance
     */
    T setParentComponent(Component parentComponent);

    /**
     * Sets the dialog title.
     * @param title Title of the dialog.
     * @return The builder instance
     */
    T setTitle(String title);

    /**
     * Sets the DialogMessageType of the dialog.
     * @param messageType DialogMessageType to be used.
     * @return The builder instance
     */
    T setMessageType(DialogMessageType messageType);

    /**
     * Sets the dialog's icon.
     * @param icon The icon to set
     * @return The builder instance
     */
    T setIcon(Icon icon);

    /**
     * Sets the message of the dialog.
     * @param message Message to be displayed in the dialog
     * @return The builder instance
     */
    T setMessage(Object message);

    /**
     * Builds the dialog based on the builder.
     * @return The created dialog
     */
    Dialog<T> build();

}
