/*
 * @(#)PointConstrainer.java 5.1
 *
 */

package de.renew.draw.ui.ontology;

import java.awt.Point;


/**
 * Interface to constrain a Point. This can be used to implement
 * different kinds of grids.
 * <hr>
 * <b>Design Patterns</b><P>
 * <img src="images/red-ball-small.gif" width=6 height=6 alt=" o ">
 * <b><a href=../pattlets/sld034.htm>Strategy</a></b><br>
 * DrawingView is the StrategyContext.<br>
 *
 * @see DrawingView
 */
public interface PointConstrainer {

    /**
     * Constrains the given point.
     * @param p point to be constrained
     * @return constrained point.
     */
    Point constrainPoint(Point p);

    /**
     * Gets the x offset to move an object.
     * @return x offset
     */
    int getStepX();

    /**
     * Gets the y offset to move an object.
     * @return y offset
     */
    int getStepY();
}