package de.renew.draw.ui.ontology;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

/**
 * Interface for factories that create visual separators for menus and popup menus.
 * <p>
 * Implementations of this interface will provide a way to create
 * {@link JMenuItem} or {@link JPopupMenu.Separator} objects that
 * will be rendered as a separator in the menu structure.
 * </p>
 */
public interface MenuSeparatorFactory {

    /**
     * Creates a Separator for a menu.
     *
     * @return a separator as an Item
     */
    JMenuItem createSeparator();

    /**
     * Create {@link JPopupMenu.Separator} add the given <b>menuID</b> to<br>
     * the separator's id (idOfSeparatorFactory + "." + menuID + ".separator").
     *
     * @param menuID The separator identifier
     * @return the created {@link JPopupMenu.Separator}
     */
    JPopupMenu.Separator createJPopupMenuSeparator(Object menuID);
}
