package de.renew.draw.ui.ontology;

/**
 * Enum describing the different positions within a menu section where an entry can be added.
 */
public enum MenuSectionPosition {
    /** The position at the beginning of the section (new first entry). */
    BEGINNING,
    /**
     * The position at the middle of the section, depending on the number of entries in the section.
     * If there is an even number of entries, the new entry is added as the new middle entry.
     * If there is an uneven number of entries, the new entry is added in front of the current middle entry.
     */
    MIDDLE,
    /** The position at the end of the section (new last entry). */
    END
}
