package de.renew.draw.ui.ontology;

import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JFrame;

import de.renew.draw.storables.ontology.Drawing;


/**
 * View container for a drawing.
 */
public interface DrawingViewContainer {

    /**
     * Gives the location of the drawing view controller.
     * @return the location of the drawing view container
     */
    Point getLocation();

    /**
     * Gives the size of the drawing view container.
     * @return the size of the drawing view container
     */
    Dimension getSize();

    /**
     * Function called when the drawing view container releases the discard.
     */
    void onDiscardRelease();

    /**
     * Gives the view of the drawing view container.
     * @return the view of the drawing view container
     */
    DrawingView view();

    /**
     * Validates the drawing view container.
     */
    void validate();

    /**
     * Sets the title of the drawing view container to the name of the given drawing.
     * @param drawing the drawing which name should be used as title of the drawing view container
     */
    void setTitle(Drawing drawing);

    /**
     * Sets the title to the given String.
     * @param title new title of the drawing view container
     */
    void setTitle(String title);

    /**
     * Sets the visibility of the drawing view container.
     * @param b is the drawing window visible true/false
     */
    void setVisible(boolean b);

    /**
     * Requests the focus.
     */
    void requestFocus();

    /**
     * Sets the state to the new value.
     * @param state the new state
     */
    void setState(int state);

    /**
     * Gives the main frame of the drawing view container.
     * @return the frame of the drawing view container
     */
    JFrame getFrame();

    /**
     * Discards the drawing view container.
     */
    void discard();
}